function [] = synsubset_multi(varargin)
%This is a high order script that allows you to synsubset in an automated
%fashion across an entire directory.  Note: I apparently had another way of
%doing this using subsetmatmkr and a script file, but this should be
%slightly more flexible and easier to use...just more work for me right
%now.
%Synatax:   [] = synsubset_multi('ref_ch','SYNPO','prepost',0,'dist',5,'ori','PSD','termi','SYN')
%Input:     'prepost' = determine also whether the third point should be
%               closer to ori or termi.  supercedes everything.  Default =
%               [], or off, 0 = near ori, 1 = near termi.  NOTE: for
%               prepost to work you must enter all of dir and files.
%           'dist' = the distance by which this new subclass is determined,
%               specifically, it is the distance of the selected channel
%               from the origin that is specified here.  Default = 5.
%           'ref_ch' = the reference channel, e.g., the channel used for
%               subclassification (SYNPO, FXR1, etc.)  This is required,
%               default = SYNPO;
%           'dir_in' = The directory where the data is.
%           'ori' = the origin channel name.  Default = 'PSD'
%           'termi' = the termini channel name.  Default = 'SYN'
%Output:    none

[ref_ch,dir_in,prepost,dist,ori,termi] = parse(varargin);

%now grab those directory names
dir_struct = dir(dir_in);  %grab the directory information
idx = [dir_struct.isdir];   %grab all of the isdir numbers
idx(1:2) = 0;               %remove the first two directories
dirnames = {dir_struct.name};   %grab the all of the names in the root
dirnames = dirnames(idx);  %don't want the first two
dir_tmp = repmat([dir_in filesep],size(dirnames'));    %replicated the directory name for appending

%prepare the output directory
sep_loc = strfind(dir_in,filesep);
out_tmp = [dir_in(1:sep_loc(end)),'SubsetClasses'];
mkdir(dir_in(1:sep_loc(end)),'SubsetClasses')  %make the output root directories
out_tmp = repmat([out_tmp filesep],size(dirnames'));    %replicated the out_put name for appending
out_list = horzcat(cellstr(out_tmp),dirnames');      %now each cell contains the full output directory path

dirnames = cellstr([dir_tmp char(dirnames')]);      %now each cell contains the full directory path

if ~isempty(dirnames)   %if the root only have files, then no need to go further
    while 1     %we are going to dig until all sub_dirs are found
        dir_tmp = [];   %clear!
        dir_end = 0;    %reset
        out_tmp = [];
        %level in
        for i = 1:size(dirnames,1)  %for each dir_step down one
            curr_dir = dirnames{i};     %current directory
            dir_info = dir(curr_dir); %grab the current dir
            curr_names = {dir_info.name};   %grab the all of the names
            idx = [dir_info.isdir];   %grab all of the isdir numbers
            filenames = curr_names(~idx);   %grab the files first
            idx(1:2) = 0;   %toss the first two
            dir_nxt = curr_names(idx);    %the directories
            %for every directory see if there are csvs around that fit the
            %desired criteria
            filenames = findfiletype(filenames,'.csv');  %only csvs
            %now lets look for the necessary files
            if ~isempty(filenames)  %found csv files
                %initiate
                ref_ch_num = []; ori_ch_num = []; termi_ch_num = [];
                %parse filenames
                for j = 1:size(filenames,2)
                    if isempty(prepost)    %depending on the prepost parameter we are looking for different files
                        if ~isempty(strfind(filenames{j},ref_ch))&&~isempty(strfind(filenames{j},'aprop'))    %see if we find our reference channel
                            ref_ch_num = j;
                        end
                    else    %if prepost is selective verts are used
                        if ~isempty(strfind(filenames{j},ref_ch))&&~isempty(strfind(filenames{j},'avert'))    %see if we find our reference channel
                            ref_ch_num = j;
                        end
                        %prepost we will need to find a couple of other
                        %files
                        if ~isempty(strfind(filenames{j},ori))&&~isempty(strfind(filenames{j},'avert'))    %see if we find our reference channel
                            ori_ch_num = j;
                        end
                        if ~isempty(strfind(filenames{j},termi))&&~isempty(strfind(filenames{j},'avert'))    %see if we find our reference channel
                            termi_ch_num = j;
                        end
                    end
                end
                %Now try subclass classification
                if ~isempty(ref_ch_num)
                    curr_out = [out_list{i,1},ref_ch,'-',out_list{i,2}];     %current output directory
                    mkdir(curr_out);     %create output this directory
                    if isempty(prepost)     %no prepost desires
                        %create current path
                        %We are going to assume that all the properties files
                        %is in the same directory as our reference file.  This
                        %should always be the case!  Thus 'dir2' = curr_dir.
                        synsubset('dist',dist,'dir1',[curr_dir,filesep],'file1',filenames{ref_ch_num},'dir2',[curr_dir,filesep],'dirsav',curr_out);
                    else  %prepost is actively enforced
                        synsubset('dist',dist,'prepost',prepost,'dir1',[curr_dir,filesep],'file1',filenames{ref_ch_num},'dir2',[curr_dir,filesep],...
                            'file2',filenames{ori_ch_num},'dir3',[curr_dir,filesep],'file3',filenames{termi_ch_num},'dirsav',curr_out);
                    end
                else
                    curr_out = [out_list{i,1} out_list{i,2}];     %current output directory
                    mkdir(out_list{i,1},out_list{i,2});     %copy over this directory
                end
            else
                curr_out = [out_list{i,1} out_list{i,2}];     %current output directory
                mkdir(out_list{i,1},out_list{i,2});     %copy over this directory
            end
            %Iterate on
            if isempty(dir_nxt)   %bottom
                dir_end = dir_end+1;    %one path to its conclusion
            else    %not the bottom
                curr_dir = repmat([curr_dir filesep],size(dir_nxt'));    %replicated the directory name for appending
                dir_tmp = vertcat(dir_tmp,cellstr([curr_dir char(dir_nxt')]));      %now each cell contains the full directory path
                curr_out = repmat([curr_out filesep],size(dir_nxt'));    %replicated the out_put name for appending
                out_tmp = vertcat(out_tmp,horzcat(cellstr(curr_out),dir_nxt'));      %now each cell contains the full output directory path
            end
        end
        if dir_end==size(dirnames,1)    %all directories are at an end
            break
        else    %move next level down
            dirnames = dir_tmp;
            out_list = out_tmp;
        end
    end
end

%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [ref_ch,dir_in,prepost,dist,ori,termi] = parse(input)

dir_in = [];
prepost = [];
dist = 5;
ref_ch = 'SYNPO';
ori = 'PSD';
termi = 'SYN';

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'dir_in'
                    dir_in = input{1,i+1};
                case 'prepost'
                    prepost = input{1,i+1};
                case 'dist'
                    dist = input{1,i+1};
                case 'ref_ch'
                    ref_ch = input{1,i+1};
                case 'ori'
                    ori = input{1,i+1};
                case 'termi'
                    termi = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        else
            error(['The parameters you entered is incorrect.  Please check help.']);
        end
    end
end

%Get the location of the files you want to open
if isempty(dir_in)
    dir_in = uigetdir2('','Directory where your classified synapses are');    %get the directory
end

%--------------------------------------------------------------------------
function [emptystatus,filenum] = filecheck(curr_dir)

dir_info = dir(curr_dir); %grab the current dir
curr_names = {dir_info.name};   %grab the all of the names
idx = [dir_info.isdir];   %grab all of the isdir numbers
filenames = curr_names(~idx);   %grab the files first
filenames = findfiletype(filenames,'.csv');  %only csvs

%is the directory empty of CSV files
if isempty(filenames)
    emptystatus = 1;
    filenum = 0;
else
    emptystatus = 0;
    filenum = size(filenames,2);
end